local Player = ...
assert(Player,"[ScreenStageInformation StepInfo] needs a player passed in")

local textC
local mainFont = "_dejavu sans Bold 24px"
local mainZoom = 16/24
local secondZoom = 12/24

return Def.ActorFrame{
	-- base
	LoadActor(THEME:GetPathG("_stageinfo","box"))..{
		OffCommand=cmd(bouncebegin,0.25;zoomy,0);
	};

	Def.ActorFrame{
		Name="TextArea";
		InitCommand=function(self)
			textC = self:GetChildren();
			self:y(-16)
		end;
		BeginCommand=function(self)
			local song = SongOrCourse()
			local steps = StepsOrTrail(Player)
			local diffText = "no"
			local meterText = "00"
			local panelText = "[?]"
			local authorText = "nul"
			local bpmText = "? bpm"

			if song and steps then
				local st = steps:GetStepsType()
				local diff = steps:GetDifficulty()

				diffText = GetCustomDifficulty(st,diff,nil)
				textC.DifficultyName:diffuse(CustomDifficultyToColor(diffText))
				textC.DifficultyName:shadowcolor( BoostColor(CustomDifficultyToColor(diffText),0.4) )

				meterText = steps:GetMeter()
				textC.DifficultyMeter:diffuse(CustomDifficultyToColor(diffText))
				textC.DifficultyMeter:shadowcolor( BoostColor(CustomDifficultyToColor(diffText),0.4) )

				-- fix for things
				if diff == 'Difficulty_Edit' and steps:GetDescription() ~= "" then
					diffText = steps:GetDescription()
				else
					diffText = CustomDifficultyToLocalizedString(GetCustomDifficulty(st,diff,nil))
				end

				panelText = THEME:GetString("Panel",ToEnumShortString(st))
				if steps:GetAuthorCredit() ~= "" then
					authorText = steps:GetAuthorCredit()
				else
					authorText = steps:GetDescription()
				end

				-- bpms of chart
				local splitBPM = song:IsStepsUsingDifferentTiming(steps)
				local bpms = splitBPM and steps:GetDisplayBpms() or song:GetDisplayBpms()
				if bpms[1] == bpms[2] then
					bpmText = string.format("%i BPM",bpms[1])
				else
					bpmText = string.format("%i-%i BPM",bpms[1],bpms[2])
				end
			else
				diffText = ""
				meterText = ""
				panelText = ""
				authorText = ""
				bpmText = ""
			end

			textC.DifficultyName:settext(diffText)
			textC.DifficultyMeter:settext(meterText)
			textC.Panels:settext(panelText)
			textC.ChartAuthor:settext(authorText)
			textC.BPMs:settext(bpmText)
		end;

		LoadFont(mainFont)..{
			Name="Panels";
			InitCommand=cmd(x,-88;y,-16;halign,1;shadowlength,1;diffusebottomedge,color("#BBBBBB");zoom,mainZoom);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
		LoadFont(mainFont)..{
			Name="DifficultyName";
			InitCommand=cmd(x,-84;y,-16;halign,0;shadowlength,1;zoom,mainZoom;uppercase,true);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
		LoadFont(mainFont)..{
			Name="DifficultyMeter";
			InitCommand=cmd(x,36;y,-16;halign,1;shadowlength,1;zoom,mainZoom);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};

		Def.Quad{
			Name="Separator1";
			InitCommand=cmd(y,-5;zoomto,224,1;fadeleft,0.125;faderight,0.125);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};

		-- sub text area
		LoadFont(mainFont)..{
			Name="ChartAuthor";
			InitCommand=cmd(x,-108;y,5;halign,0;shadowlength,1;zoom,secondZoom);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
		-- bpms for selected chart
		LoadFont(mainFont)..{
			Name="BPMs";
			InitCommand=cmd(x,-108;y,20;halign,0;shadowlength,1;zoom,secondZoom);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};

		-- player's best score on chart (if existing)
	};
};